#version 330
#extension GL_EXT_gpu_shader4 : enable
//Marching InfinitelyMod01.fsh  by  Julius
//https://www.shadertoy.com/view/XsKfRR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct ray { vec3 origin; vec3 normalizedDirection; };

ray cameraRay(vec2 uv, vec3 camera) {    
    vec2 pos = uv - vec2(.5, .5);
    
	return ray(camera, normalize(vec3(pos.x, pos.y, 1)));
}

float dPlane(vec3 p) {
	return p.y;
}

float dSphere(vec3 p, float radius) {
	return length(p) - radius;
}

float dTorus(vec3 p, float radius, float strength) {
	vec2 mapped = vec2(length(p.xy) - radius, p.z);
        
    return length(mapped) - strength;
}

float dUnion(float d1, float d2)
{
    return min(d1,d2);
}

float smin(float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float dBlend(float d1, float d2, float k)
{
    return smin(d1,d2, k);
}

float rand(vec3 v){
    return fract(sin(dot(v ,vec3(12.9898,78.233,.0235))) * 43758.5453);
}

vec3 stars(vec3 direction) {
	if(rand(direction) > .0001)
        return vec3(0,0,0);
    else
        return vec3(1,1,1);
}

vec3 checkered(vec2 location) {
	return ((mod(location.x, 2.) > 1.) != (mod(location.y, 2.) > 1.)) ? vec3(.3,.7,.3) : vec3(.4,1,.4);
}

vec3 foggy(vec3 color, float d, float view) {
    float viewFactor = max(1. - d / view, 0.);
    
	return color * viewFactor + vec3(.5, .5, .5) * (1. - viewFactor);
}

float dRepeatStuff(vec3 p, vec3 period)
{
    vec3 mapped = mod(p, period)-0.5*period;
    return dBlend(dTorus(mapped, 3., .3), dSphere(mapped - vec3(0, 2.3,0), .3), .3);
}

float dist(vec3 p) {
    float d = dPlane(p);
    d = dBlend(d, dRepeatStuff(p, vec3(0, 0, 10.)), 2.);
    return d;
}

vec3 normal(vec3 p) {
    float epsilon = .0005;
    
    float base = dist(p);
    
    return normalize(vec3(
        dist(p + vec3(epsilon, 0, 0)) - base, 
        dist(p + vec3(0, epsilon, 0)) - base, 
        dist(p + vec3(0, 0, epsilon)) - base));
}

vec3 marchColor(ray r) {
    vec3 p = r.origin;
    float total = 100.;
    vec3 color = stars(r.normalizedDirection);
    vec3 n = vec3(-1, 1, -1);
    for(int i=0; i<300; i++) {
        float d = dist(p);
        if(d < .001) {
        	color = checkered(p.xz);
            total = length(p - r.origin);
            n = normal(p);
        }
        
        p += d * r.normalizedDirection;
    }
    
    float lightFactor = dot(n, vec3(-.5, .5, -.5));
    vec3 shadedColor = color * (.1 + .9 * lightFactor);
    
    return foggy(shadedColor, total, (r.origin.z + 150.) * .1);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (gl_FragCoord.xy - vec2(0, .5 * (iResolution.y - iResolution.x))) /iResolution.xx;

    ray r = cameraRay(uv, vec3(0,1.5,iTime * iTime));
    
    vec3 col = marchColor(r);
    gl_FragColor = vec4(col,1.0);
}